/******************************************************************************
 CAdaFrontTask.h

			Source File For CAdaFrontTask Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	by Manuel A. Perez

 ******************************************************************************/

#include "CAdaFrontTask.h"
#include "CAdaApp.h"
#include "CSourceDocument.h"
#include "CLibrary.h"

#include <TBUtilities.h>
#include <Exceptions.h>
#include <stdio.h>
#include <stdlib.h>
#include "ErrMessages.h"

extern	CApplication *gApplication;	/* The application */
extern	OSType	gSignature;			/* Creator for Application's files	*/


/****
 *	IAdaFrontTask
 *
 ****/
void	CAdaFrontTask::IAdaFrontTask(CSourceDocument *doc)
{
	Str255	n;

	GetIndString(n, 20020, 1);
	ICompileTask(doc, n);
	SetPartID(kFront);
}

/****
 *	WriteOptions
 *
 ****/

void	CAdaFrontTask::WriteOptions(void)
{
Str255 file, fileName, srcFullPath;
FILE *fp;
CLibrary *lib;
CAdaApp	*app = (CAdaApp *) gApplication;

	// Write adafront compile options to disk
	CopyPString(procPath, file);
	ConcatPStrings(file, procName);
	ConcatPStrings(file, "\p.options");
	PtoCstr(file);

	_fcreator = gSignature;
	if (fp = fopen((char *)file, "w")) {
		fprintf(fp, "%#s\n", procName);

		// Get User Library
		lib = app->GetUserLibrary();
		lib->WriteOptions(fp);

		// Source File to Compile
		itsDoc->GetFilePath(srcFullPath);
		itsDoc->GetFileName(fileName);
		ConcatPStrings(srcFullPath, fileName);

		fprintf(fp, "%#s\n", srcFullPath);
		fclose(fp);
	}
	else {
		// Fail opening adafront options
		Failure(errWritingOptions, 0);
	}

}


/****
 *	AnnounceWithSound()
 *
 *	Play a sound only if this task finished with an error.  If it finished
 *	successfully, don't play a sound because adagen will run next.
 *
 ****/

void	CAdaFrontTask::AnnounceWithSound(void)
{
	switch (CompletionCode()) {
		case RC_INTERNAL_ERROR:
		case RC_ERRORS:
			inherited::AnnounceWithSound();
			break;
	}
}

